/*
 * my_profiler.h  - simple routines to measure the time consumption of some code
 *
 * Copyright (C) 2002 Benjamin Hummel (benjamin@datamaze.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef MY_PROFILER_H
#define MY_PROFILER_H

/* init the "profiler" */
void
myprofiler_init (void);

/* start the timer for one block,
   the first is a unique number between 0 and MYPROFILER_DATASIZE-1 (see my_prfiler.c)
   to identify the code block, the second is a name used for the statistics */
void
myprofiler_start (int, char *);

/* stop the timer for the block,
   the parameter should be the same number as in the call to myprofiler_start */
void
myprofiler_stop (int);

/* print out some statistics */
void
myprofiler_print (void);

#endif /* !MY_PROFILER_H */
