/*
 * somedefs.h  - Some definitions used everywhere in Aglaia
 *
 * Copyright (C) 2002 Benjamin Hummel (benjamin@datamaze.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef SOMEDEFS_H
#define SOMEDEFS_H

/* Appliction strings */
#define APP_NAME "aglaia"
#define APP_VERSION "0.1"

#define DEFAULT_OUTPUT "img"

/* define speed for altering values */
#define STEPSIZE 16

/* macro for verbose output */
#define VERBOSE_PRINTF(s) if(verbose){printf(s);fflush(stdout);}

/* want a bool */
typedef int BOOL;
#define TRUE  1
#define FALSE 0

/* I think BYTE clarifies meaning */
typedef unsigned char BYTE;

/* effect names */
enum {
	FX_NONE = 0,
	FX_DELTA,
	FX_SOBEL,
	FX_AND,
	FX_XOR,
	FX_COLORIZE,
	FX_COLINV,
	FX_COLBLEND
};

#define FX_MIN FX_NONE
#define FX_MAX FX_COLBLEND

/* define capture modes */
enum {
	CAP_MANUAL = 0,
	CAP_SINGLE,
	CAP_TIME,
	CAP_FRAMES
};

/* struct for color */
typedef struct rgba_struct
{
	BYTE r, g, b, a;
} rgba;

/* define some colors */
#define BLACK   { 0, 0, 0, 0 };
#define WHITE   { 255, 255, 255, 255 };
#define RED     { 255, 0, 0, 0 }
#define GREEN   { 0, 255, 0, 0 };
#define BLUE    { 0, 0, 255, 0 };
#define CYAN    { 0, 255, 255, 0 };
#define MAGENTA { 255, 0, 255, 0 };
#define YELLOW  { 255, 255, 0, 0 };


#endif /* !SOMEDEFS_H */
